package com.ximai.mes.pro.domain.vo.proWorkOrder;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 装箱条码打印参数
 *
 * @author lcc
 * @date 2024-02-29
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class BuildPackageParams {

    @ApiModelProperty("工单ID")
    private Long workorderId;

    @ApiModelProperty("生产工单指令表ID")
    private Long workorderSoDirectiveId;

    @ApiModelProperty("生产工单尺码表ID")
    private Long workorderSoSizeItemId;

    @ApiModelProperty("包装数量")
    private BigDecimal packNum;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("起始页码")
    private Integer currentSheet;

    @ApiModelProperty("张数")
    private Integer sheetCount;

    @ApiModelProperty("开始索引")
    private Integer beginIndex=0;

    @ApiModelProperty("报工ID，可为空")
    private Long feedbackId;

    @ApiModelProperty("派工表ID，可为空")
    private Long taskWorkunitId;

    @ApiModelProperty("小包数量")
    private Integer minPackageNum;

    @ApiModelProperty
    private Integer printTime=0;

    @ApiModelProperty("录入人员")
    private String inputBy;

    @ApiModelProperty("检验人员")
    private String checkBy;

}
