package com.ximai.mes.pro.domain.to;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProWorkOrderBomTo1 {
    /**
     * SAP的物料号
     */
    @JSONField(name = "IDNRK")
    private String sapItemCode;

    /**
     * 预留/相关需求的编号
     */
    @JSONField(name = "RSNUM")
    private String requirementNumber;

    /**
     * 预留/相关需求的项目编号
     */
    @JSONField(name = "RSPOS")
    private String requirementProjectNumber;

    /**
     * 组件数量
     */
    @JSONField(name = "BDMNG")
    private String quantity;

    /**
     * 存储地点
     */
    @JSONField(name = "LGORT")
    private String storeAddr;

    /**
     * 备选物料清单
     */
    @JSONField(name = "STLAL")
    private String alternativeBill;

    /**
     * 报废百分比
     */
    @JSONField(name = "AUSCH")
    private String scrapPercentage;

    /**
     * 单位用量
     */
    @JSONField(name = "ESMNG")
    private String unitUsage;

    /**
     * 虚拟项目标识
     */
    @JSONField(name = "DUMPS")
    private String virtualProjectLog;

    /**
     * 基本计量单位
     */
    @JSONField(name = "MEINS")
    private String unitOfMeasure;

    /**
     * 存储地点
     */
    @JSONField(name = "UMLGO")
    private String storeAddr2;

    /**
     * 工序编号
     */
    @JSONField(name = "VORNR")
    private String processRef;

    /**
     * 副单位
     */
    private String deputyUnitOfMeasure;

    /**
     * 主副单位转换比例
     */
    private String  unitConvert;

}
