package com.ximai.mes.pro.domain.productionSolution;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 生产版本工序对象 pro_production_solution_process
 *
 * @author zht
 * @date 2024-03-05
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProProductionSolutionProcess {

    /**
     * ID
     */
    @TableId(type = IdType.AUTO)
    private Long productionSolutionProcessId;

    /**
     * 生产版本ID
     */
    @Excel(name = "生产版本ID")
    private Long productionSolutionId;

    /**
     * 记录ID
     */
    @Excel(name = "记录ID")
    private Long recordId;

    /**
     * 工序id
     */
    @Excel(name = "工序id")
    private Long processId;

    /**
     * 工作中心
     */
    @Excel(name = "工作中心")
    private Long workstationId;

    /**
     * 关键工序
     */
    @Excel(name = "关键工序")
    private String keyFlag;

    /**
     * 是否检验
     */
    @Excel(name = "是否检验")
    private String isCheck;

    /**
     * 固化时间
     */
    @Excel(name = "固化时间")
    private BigDecimal solidifyTime;

    /**
     * 序号
     */
    @Excel(name = "序号")
    private String idx;

    /**
     * 工作中心编码
     */
    @Excel(name = "工作中心编码")
    private String workstationCode;

    /**
     * 加工方式
     */
    @Excel(name = "加工方式")
    private String processingMethod;

    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    private String processName;

    /**
     * 工序备注
     */
    @Excel(name = "工序备注")
    private String processRemark;

    /**
     * 基本数量
     */
    @Excel(name = "基本数量")
    private BigDecimal quantity;

    /**
     * 工序计量单位
     */
    @Excel(name = "工序计量单位")
    private String unitOfMeasure;

    /**
     * 副單位
     */
    @Excel(name = "副单位")
    private String deputyUnitOfMeasure;

    /**
     * 主副单位转换比例
     */
    @Excel(name = "主副单位转换比例")
    private BigDecimal unitConvert;

    /**
     * 雇员数量
     */
    @Excel(name = "雇员数量")
    private int employeesNum;

    /**
     * 标准工时
     */
    @Excel(name = "标准工时")
    private BigDecimal stdWorkingTime;

    /**
     * 换型时间
     */
    @Excel(name = "换型时间")
    private BigDecimal lineBreakTime;

    /**
     * 工时单位
     */
    @Excel(name = "工时单位")
    private String stdWorkingTimeUom;

    /**
     * 控制码
     */
    @TableField(exist = false)
    private String controlCode;

    /**
     * 是否外协
     */
    @ApiModelProperty("是否外协")
    private String outsourced;

    /**
     * 排序号
     */
    @ApiModelProperty("排序号")
    private Integer serial;

    /**
     * 采购信息记录号
     */
    @Excel(name = "采购信息记录号")
    private String procurementInformationId;

    /**
     * 供应商科目编号
     */
    @Excel(name = "供应商科目编号")
    private String vendorSubjectId;

    /**
     * 采购信息记录中的净价
     */
    @Excel(name = "采购信息记录中的净价")
    private BigDecimal netPrice;

    /**
     * 采购组织
     */
    @Excel(name = "采购组织")
    private String procurementOrganization;

    /**
     * 备注
     */
    @Excel(name = "备注")
    private String remark;

    /** 封切机开边 */
    @Excel(name = "封切机开边")
    private String sacmForEdgeOpening;

    /** 封切机粘贴复合 */
    @Excel(name = "封切机粘贴复合")
    private String sacmForPasteComposite;

    /** 封切机热复合 */
    @Excel(name = "封切机热复合")
    private String sacmForThermalComposite;

    /** 封切机贴标 */
    @Excel(name = "封切机贴标")
    private String sacmForLabeling;

    /** 封切机装扣 */
    @Excel(name = "封切机装扣")
    private String sacmForBuckleUp;

    /** 封切机压痕 */
    @Excel(name = "封切机压痕")
    private String sacmForCreasing;

    /** 封切机风琴 */
    @Excel(name = "封切机风琴")
    private String sacmForOrgan;

    /** 封切机热切 */
    @Excel(name = "封切机热切")
    private String sacmForThermalCutting;

    /** 封切机热自合 */
    @Excel(name = "封切机热自合")
    private String sacmForThermalSelfFusion;

    /** 封切机压齿 */
    @Excel(name = "封切机压齿")
    private String sacmForMolarTooth;

    /** 封切机分切 */
    @Excel(name = "封切机分切")
    private String sacmForSlitting;
    /**
     * 规格书
     */
    @ApiModelProperty("单价")
    private BigDecimal unitPrice;
    /**
     * 工序流向id
     */
    private Long directionProcessId;

    /**
     * 工序流向编码
     */
    private String directionProcessCode;


    /**
     * 工序流向编码
     */
    private String directionProcessName;

}
