package com.ximai.mes.pro.domain.productionSolution;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 生产版本BOM行对象 pro_production_solution_bom_item
 *
 * @author zht
 * @date 2024-03-05
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProProductionSolutionBomItem {

    /**
     * ID
     */
    @TableId(type = IdType.AUTO)
    private Long bomItemId;

    /**
     * 抬头ID
     */
    @Excel(name = "抬头ID")
    private Long bomHeadId;

    /**
     * 序号
     */
    @Excel(name = "序号")
    private String idx;

    /**
     * BOM 组件
     */
    @Excel(name = "BOM 组件")
    private String sapItemCode;

    /**
     * 物料id
     */
    private Long itemId;
    /**
     * 物料描述
     */
    @Excel(name = "物料描述")
    private String itemName;

    /**
     * 项目类别（物料单）
     */
    @Excel(name = "项目类别", readConverterExp = "物料单")
    private String  itemClass;

    /**
     * 计量单位
     */
    @Excel(name = "计量单位")
    private String unitOfMeasure;

    /**
     * 组件数量
     */
    @Excel(name = "组件数量")
    private BigDecimal quantity;

    /**
     * 标识：与成本核算相关的项目
     */
    @Excel(name = "标识：与成本核算相关的项目")
    private String  costAccountingMarking;

    /**
     * 报废百分比
     */
    @Excel(name = "报废百分比")
    private BigDecimal scrapPercentage;

    /**
     * 特殊获取
     */
    @Excel(name = "特殊获取")
    private String  specialAccess;

    /**
     * 物料供应标识
     */
    @Excel(name = "物料供应标识")
    private String  itemSupplyMarking;

    /**
     * 替代组
     */
    @Excel(name = "替代组")
    private String alternativeGroup;

    /**
     * 替代优先级
     */
    @Excel(name = "替代优先级")
    private BigDecimal alternativePriorities;

    /**
     * 策略
     */
    @Excel(name = "策略")
    private String alternativeStrategy;

    /**
     * 使用概率
     */
    @Excel(name = "使用概率")
    private String alternativeProbability;

    /**
     * BOM行备注
     */
    @Excel(name = "BOM行备注")
    private String bomItemRemark;

    /**
     * 物料备注
     */
    @Excel(name = "物料备注")
    private String itemRemark;

    /**
     * 是否固定数量
     */
    @Excel(name = "是否固定数量")
    private String  isFixed;
}
