package com.ximai.mes.pro.domain.productionMake;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 量产制作工序物料对象 pro_production_make_process_item
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
public class ProProductionMakeProcessItem extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键id */
    private Long productionMakeProcessItemId;

    /** 量产制作工序ID */
    @Excel(name = "量产制作工序ID")
    private Long productionMakeProcessId;

    /** 产品物料ID */
    @Excel(name = "产品物料ID")
    private Long itemId;

    /** 单位 */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /** 组件数量 */
    @Excel(name = "组件数量")
    private BigDecimal quantity;
    private String itemName;

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public void setProductionMakeProcessItemId(Long productionMakeProcessItemId)
    {
        this.productionMakeProcessItemId = productionMakeProcessItemId;
    }

    public Long getProductionMakeProcessItemId()
    {
        return productionMakeProcessItemId;
    }
    public void setProductionMakeProcessId(Long productionMakeProcessId)
    {
        this.productionMakeProcessId = productionMakeProcessId;
    }

    public Long getProductionMakeProcessId()
    {
        return productionMakeProcessId;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setUnitOfMeasure(String unitOfMeasure)
    {
        this.unitOfMeasure = unitOfMeasure;
    }

    public String getUnitOfMeasure()
    {
        return unitOfMeasure;
    }
    public void setQuantity(BigDecimal quantity)
    {
        this.quantity = quantity;
    }

    public BigDecimal getQuantity()
    {
        return quantity;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("productionMakeProcessItemId", getProductionMakeProcessItemId())
            .append("productionMakeProcessId", getProductionMakeProcessId())
            .append("itemId", getItemId())
            .append("unitOfMeasure", getUnitOfMeasure())
            .append("quantity", getQuantity())
            .append("remark", getRemark())
            .toString();
    }
}
