package com.ximai.mes.pro.domain;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import com.ximai.common.utils.bean.BeanUtils;
import com.ximai.mes.pro.domain.vo.ProAllocationItemList;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Data;

/**
 * 工作中心发料申请对象 pro_workstation_material
 *
 * @author generator
 * @date 2024-07-26
 */
@Data
public class ProWorkstationMaterial extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主建id */
    @TableId
    private Long workstationMaterialId;

    /** 申请号 */
    @Excel(name = "申请号")
    private String applyNo;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    /** 任务ID */
    @Excel(name = "任务ID")
    private Long taskId;

    /** 派工记录ID */
    @Excel(name = "派工记录ID")
    private Long taskWorkunitId;

    /** 申请类型 */
    @Excel(name = "申请类型")
    private Long applyType;

    /** 申请数量 */
    @Excel(name = "申请数量")
    private BigDecimal applyNum;

    /** 领料类型 */
    @Excel(name = "领料类型")
    private Long materialType;

    /** 领料原因 */
    @Excel(name = "领料原因")
    private String pickingReason;

    /** 工作中心ID */
    @Excel(name = "工作中心ID")
    private Long workstationId;

    /** 工作中心编码 */
    @Excel(name = "工作中心编码")
    private String workstationCode;

    /** 工作中心名称 */
    @Excel(name = "工作中心名称")
    private String workstationName;

    /** 是否结案 */
    @Excel(name = "是否结案")
    private String windCase;

    /** 已发放数量 */
    @Excel(name = "已发放数量")
    private BigDecimal grantNum;

    /** 备注 */
    @Excel(name = "备注")
    private String remak;

    /** 预留字段1 */
    @Excel(name = "预留字段1")
    private String attr1;

    /** 预留字段2 */
    @Excel(name = "预留字段2")
    private String attr2;

    /** 预留字段3 */
    @Excel(name = "预留字段3")
    private Long attr3;

    /** 预留字段4 */
    @Excel(name = "预留字段4")
    private Long attr4;

    /** 工作单元id */
    @Excel(name = "工作单元id")
    private Long workunitId;

    /** 工作单元名称 */
    @Excel(name = "工作单元名称")
    private String workunitName;

    /** 工作单元编码 */
    @Excel(name = "工作单元编码")
    private String workunitCode;

    /** 物料编码*/
    private String sapItemCode;

    /** 需求日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "需求日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /** 物料信息 */
    @Excel(name = "物料信息")
    private List<ProAllocationItemList> itemList;




     public ProWorkstationMaterial getProWorkstationMaterial(ProWorkstationMaterial proWorkstationMateriala){
         ProWorkstationMaterial proWorkstationMaterial1 = new ProWorkstationMaterial();
         BeanUtils.copyProperties(proWorkstationMateriala,proWorkstationMaterial1);
         return proWorkstationMaterial1;
     }




}
