package com.ximai.mes.pro.domain;

import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 生产工序对象 pro_process
 *
 * @date 2022-05-12
 */
@Data
public class ProProcess extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 工序ID */
    @TableId
    private Long processId;

    /** 工序编码 */
    @Excel(name = "工序编码")
    private String processCode;

    /** 工序名称 */
    @Excel(name = "工序名称")
    private String processName;

    /** 工艺要求 */
    @Excel(name = "工艺要求")
    private String attention;

    /** 是否启用 */
    @Excel(name = "是否启用")
    private String enableFlag;

    @ApiModelProperty("是否包装工序，1:是，0:否")
    private String isPackage;

    @ApiModelProperty("是否序列号报工,1:是，0:否")
    private Integer isSerialReport;

    private String isExistTool;
    /** 预留字段1 */
    private String attr1;

    /** 预留字段2 */
    private String attr2;

    /** 预留字段3 */
    private Long attr3;

    /** 预留字段4 */
    private Long attr4;
}
