package com.ximai.mes.pro.controller.prototypeRequest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestProcessItem;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestProcessItemService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 打样申请工序物料Controller
 *
 * @author zht
 * @date 2024-01-18
 */
@RestController
@RequestMapping("/mes/pro/prototypeRequestProcessItem")
public class ProPrototypeRequestProcessItemController extends BaseController
{
    @Autowired
    private IProPrototypeRequestProcessItemService proPrototypeRequestProcessItemService;

    /**
     * 查询打样申请工序物料列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestProcessItem:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPrototypeRequestProcessItem proPrototypeRequestProcessItem)
    {
        startPage();
        List<ProPrototypeRequestProcessItem> list = proPrototypeRequestProcessItemService.selectProPrototypeRequestProcessItemList(proPrototypeRequestProcessItem);
        return getDataTable(list);
    }
    /**
     * 获取打样申请工序物料详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestProcessItem:query')")
    @GetMapping(value = "/{prototypeRequestProcessItemId}")
    public AjaxResult getInfo(@PathVariable("prototypeRequestProcessItemId") Long prototypeRequestProcessItemId)
    {
        return AjaxResult.success(proPrototypeRequestProcessItemService.selectProPrototypeRequestProcessItemByPrototypeRequestProcessItemId(prototypeRequestProcessItemId));
    }

    /**
     * 新增打样申请工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestProcessItem:add')")
    @Log(title = "打样申请工序物料", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPrototypeRequestProcessItem proPrototypeRequestProcessItem)
    {
        return toAjax(proPrototypeRequestProcessItemService.insertProPrototypeRequestProcessItem(proPrototypeRequestProcessItem));
    }

    /**
     * 修改打样申请工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestProcessItem:edit')")
    @Log(title = "打样申请工序物料", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPrototypeRequestProcessItem proPrototypeRequestProcessItem)
    {
        return toAjax(proPrototypeRequestProcessItemService.updateProPrototypeRequestProcessItem(proPrototypeRequestProcessItem));
    }

    /**
     * 删除打样申请工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestProcessItem:remove')")
    @Log(title = "打样申请工序物料", businessType = BusinessType.DELETE)
	@DeleteMapping("/{prototypeRequestProcessItemIds}")
    public AjaxResult remove(@PathVariable Long[] prototypeRequestProcessItemIds)
    {
        return toAjax(proPrototypeRequestProcessItemService.deleteProPrototypeRequestProcessItemByPrototypeRequestProcessItemIds(prototypeRequestProcessItemIds));
    }
}
