package com.ximai.mes.pro.controller.prototypeRequest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.prototypeRequest.ProPrototypeRequestBom;
import com.ximai.mes.pro.service.prototypeRequest.IProPrototypeRequestBomService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 打样申请BOMController
 *
 * @author zht
 * @date 2024-01-18
 */
@RestController
@RequestMapping("/mes/pro/prototypeRequestBom")
public class ProPrototypeRequestBomController extends BaseController
{
    @Autowired
    private IProPrototypeRequestBomService proPrototypeRequestBomService;

    /**
     * 查询打样申请BOM列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestBom:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPrototypeRequestBom proPrototypeRequestBom)
    {
        startPage();
        List<ProPrototypeRequestBom> list = proPrototypeRequestBomService.selectProPrototypeRequestBomList(proPrototypeRequestBom);
        return getDataTable(list);
    }

    /**
     * 获取打样申请BOM详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestBom:query')")
    @GetMapping(value = "/{bomItemId}")
    public AjaxResult getInfo(@PathVariable("bomItemId") Long bomItemId)
    {
        return AjaxResult.success(proPrototypeRequestBomService.selectProPrototypeRequestBomByBomItemId(bomItemId));
    }

    /**
     * 新增打样申请BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestBom:add')")
    @Log(title = "打样申请BOM", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPrototypeRequestBom proPrototypeRequestBom)
    {
        return toAjax(proPrototypeRequestBomService.insertProPrototypeRequestBom(proPrototypeRequestBom));
    }

    /**
     * 修改打样申请BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestBom:edit')")
    @Log(title = "打样申请BOM", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPrototypeRequestBom proPrototypeRequestBom)
    {
        return toAjax(proPrototypeRequestBomService.updateProPrototypeRequestBom(proPrototypeRequestBom));
    }

    /**
     * 删除打样申请BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeRequestBom:remove')")
    @Log(title = "打样申请BOM", businessType = BusinessType.DELETE)
	@DeleteMapping("/{bomItemIds}")
    public AjaxResult remove(@PathVariable Long[] bomItemIds)
    {
        return toAjax(proPrototypeRequestBomService.deleteProPrototypeRequestBomByBomItemIds(bomItemIds));
    }
}
