package com.ximai.mes.pro.controller.prototypeMake;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.ximai.mes.pro.domain.vo.ProPrototypeMakeProcessVo;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcess;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeProcessService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 样品制作工序Controller
 *
 * @author zht
 * @date 2024-01-20
 */
@RestController
@RequestMapping("/mes/pro/prototypeMakeProcess")
public class ProPrototypeMakeProcessController extends BaseController
{
    @Autowired
    private IProPrototypeMakeProcessService proPrototypeMakeProcessService;

    /**
     * 查询样品制作工序列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeProcess:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPrototypeMakeProcess proPrototypeMakeProcess)
    {
        startPage();
        List<ProPrototypeMakeProcessVo> list = proPrototypeMakeProcessService.selectProPrototypeMakeProcessList(proPrototypeMakeProcess);
        return getDataTable(list);
    }

    /**
     * 获取样品制作工序详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeProcess:query')")
    @GetMapping(value = "/{prototypeMakeProcessId}")
    public AjaxResult getInfo(@PathVariable("prototypeMakeProcessId") Long prototypeMakeProcessId)
    {
        return AjaxResult.success(proPrototypeMakeProcessService.selectProPrototypeMakeProcessByPrototypeMakeProcessId(prototypeMakeProcessId));
    }

    /**
     * 新增样品制作工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeProcess:add')")
    @Log(title = "样品制作工序", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPrototypeMakeProcess proPrototypeMakeProcess)
    {
        return toAjax(proPrototypeMakeProcessService.insertProPrototypeMakeProcess(proPrototypeMakeProcess));
    }

    /**
     * 修改样品制作工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeProcess:edit')")
    @Log(title = "样品制作工序", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPrototypeMakeProcess proPrototypeMakeProcess)
    {
        return toAjax(proPrototypeMakeProcessService.updateProPrototypeMakeProcess(proPrototypeMakeProcess));
    }

    /**
     * 删除样品制作工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeProcess:remove')")
    @Log(title = "样品制作工序", businessType = BusinessType.DELETE)
	@DeleteMapping("/{prototypeMakeProcessIds}")
    public AjaxResult remove(@PathVariable Long[] prototypeMakeProcessIds)
    {
        return toAjax(proPrototypeMakeProcessService.deleteProPrototypeMakeProcessByPrototypeMakeProcessIds(prototypeMakeProcessIds));
    }
}
