package com.ximai.mes.pro.controller.productionSolution;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionBom;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionBomService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 生产版本BOMController
 *
 * @author zht
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/mes/pro/productionSolutionBom")
public class ProProductionSolutionBomController extends BaseController
{
    @Autowired
    private IProProductionSolutionBomService proProductionSolutionBomService;

    /**
     * 查询生产版本BOM列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionBom:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionSolutionBom proProductionSolutionBom)
    {
        startPage();
        List<ProProductionSolutionBom> list = proProductionSolutionBomService.selectProProductionSolutionBomList(proProductionSolutionBom);
        return getDataTable(list);
    }

    /**
     * 获取生产版本BOM详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionBom:query')")
    @GetMapping(value = "/{bomItemId}")
    public AjaxResult getInfo(@PathVariable("bomItemId") Long bomItemId)
    {
        return AjaxResult.success(proProductionSolutionBomService.selectProProductionSolutionBomByBomItemId(bomItemId));
    }

    /**
     * 新增生产版本BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionBom:add')")
    @Log(title = "生产版本BOM", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionSolutionBom proProductionSolutionBom)
    {
        return toAjax(proProductionSolutionBomService.insertProProductionSolutionBom(proProductionSolutionBom));
    }

    /**
     * 修改生产版本BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionBom:edit')")
    @Log(title = "生产版本BOM", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionSolutionBom proProductionSolutionBom)
    {
        return toAjax(proProductionSolutionBomService.updateProProductionSolutionBom(proProductionSolutionBom));
    }

    /**
     * 删除生产版本BOM
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionBom:remove')")
    @Log(title = "生产版本BOM", businessType = BusinessType.DELETE)
	@DeleteMapping("/{bomItemIds}")
    public AjaxResult remove(@PathVariable Long[] bomItemIds)
    {
        return toAjax(proProductionSolutionBomService.deleteProProductionSolutionBomByBomItemIds(bomItemIds));
    }
}
