package com.ximai.mes.pro.controller.productionRequest;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionRequest.ProProductionRequestProcess;
import com.ximai.mes.pro.service.productionRequest.IProProductionRequestProcessService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 量产申请工序Controller
 *
 * @author chicheng.li
 * @date 2024-01-22
 */
@RestController
@RequestMapping("/mes/pro/productionRequestProcess")
public class ProProductionRequestProcessController extends BaseController
{
    @Autowired
    private IProProductionRequestProcessService proProductionRequestProcessService;

    /**
     * 查询量产申请工序列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcess:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionRequestProcess proProductionRequestProcess)
    {
        startPage();
        List<ProProductionRequestProcess> list = proProductionRequestProcessService.selectProProductionRequestProcessList(proProductionRequestProcess);
        return getDataTable(list);
    }

    /**
     * 获取量产申请工序详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcess:query')")
    @GetMapping(value = "/{productionRequestProcessId}")
    public AjaxResult getInfo(@PathVariable("productionRequestProcessId") Long productionRequestProcessId)
    {
        return AjaxResult.success(proProductionRequestProcessService.selectProProductionRequestProcessByProductionRequestProcessId(productionRequestProcessId));
    }

    /**
     * 新增量产申请工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcess:add')")
    @Log(title = "量产申请工序", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionRequestProcess proProductionRequestProcess)
    {
        return toAjax(proProductionRequestProcessService.insertProProductionRequestProcess(proProductionRequestProcess));
    }

    /**
     * 修改量产申请工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcess:edit')")
    @Log(title = "量产申请工序", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionRequestProcess proProductionRequestProcess)
    {
        return toAjax(proProductionRequestProcessService.updateProProductionRequestProcess(proProductionRequestProcess));
    }

    /**
     * 删除量产申请工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionRequestProcess:remove')")
    @Log(title = "量产申请工序", businessType = BusinessType.DELETE)
	@DeleteMapping("/{productionRequestProcessIds}")
    public AjaxResult remove(@PathVariable Long[] productionRequestProcessIds)
    {
        return toAjax(proProductionRequestProcessService.deleteProProductionRequestProcessByProductionRequestProcessIds(productionRequestProcessIds));
    }
}
