package com.ximai.mes.od.domain;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Date;

/**
 * 客户采购订单对象 od_purchase_order
 *
 * @author yinjinlu
 * @date 2024-01-23
 */
@Getter
@Setter
@ToString
public class OdPurchaseOrderDetail extends BaseEntity {
    private static final long serialVersionUID = 1L;

    private Long id;
    /**
     * 申购/采购单号
     */
    @Excel(name = "申购/采购单号")
    private Long orderId;

    /**
     * 产品ID
     */
    @Excel(name = "产品ID")
    private Long itemId;

    private String itemNo;

    private String sapItemCode;

    private String itemName;

    private String itemPrice;

    /**
     * 产品总数量
     */
    @Excel(name = "产品总数量")
    private Integer totalNum;

    /**
     * loss数量
     */
    @Excel(name = "loss数量")
    private Integer lossNum;

    /**
     * 产品数量
     */
    @Excel(name = "产品数量")
    private Integer num;

    /**
     * 状态
     */
    @Excel(name = "状态")
    private String state;

    /**
     * 特性值
     */
    @Excel(name = "特性值")
    private String specJson;

    /**
     * 宝绅内部品名
     */
    @Excel(name = "宝绅内部品名")
    private String productName;

    /**
     * 客户产品名称
     */
    @Excel(name = "客户产品名称")
    private String poProductName;

    /**
     * 客户产品代码
     */
    @Excel(name = "客户产品代码")
    private String poProductNo;

    /**
     * 客户颜色
     */
    @Excel(name = "客户颜色")
    private String poColor;

    /**
     * 配色号
     */
    @Excel(name = "配色号")
    private String poColorNo;

    /**
     * 产地
     */
    @Excel(name = "产地")
    private String region;

    /**
     * 尺码组
     */
    @Excel(name = "尺码组")
    private String sizeGroup;

    /**
     * 尺码
     */
    @Excel(name = "尺码")
    private String size;

    /**
     * 整/半码
     */
    @Excel(name = "整/半码")
    private String wholeYard;

    /**
     * 特殊size
     */
    @Excel(name = "特殊size")
    private String specialSize;

    /**
     * 型体号
     */
    @Excel(name = "型体号")
    private String featureNo;

    /**
     * 指令号
     */
    @Excel(name = "指令号")
    private String cmdNo;

    /**
     * 订单量
     */
    @Excel(name = "订单量")
    private Integer orderNum;

    /**
     * 产品规格
     */
    @Excel(name = "产品规格")
    private String productSize;

    /**
     * 交货日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "交货日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date deliveryDate;

    /**
     * 客户单重
     */
    @Excel(name = "客户单重")
    private String poKg;

    /**
     * 客户单号
     */
    @Excel(name = "客户单号")
    private String poOrderNo;

    /**
     * 客户单位
     */
    @Excel(name = "客户单位")
    private String customerUnit;

    /**
     * 签收人
     */
    @Excel(name = "签收人")
    private String signer;

    /**
     * 销线
     */
    @Excel(name = "销线")
    private String salePath;

    /**
     * 段别
     */
    @Excel(name = "段别")
    private String segment;

    /**
     * 版面
     */
    @Excel(name = "版面")
    private String layout;

    /**
     * 季度
     */
    @Excel(name = "季度")
    private String quarter;

    /**
     * po号
     */
    @Excel(name = "po号")
    private String poNo;

    /**
     * wip号
     */
    @Excel(name = "wip号")
    private String wipNo;

    /**
     * 装箱数
     */
    @Excel(name = "装箱数")
    private String packingNum;

    /**
     * 周期
     */
    @Excel(name = "周期")
    private String cycle;

    /**
     * sk编号
     */
    @Excel(name = "sk编号")
    private String skNo;

    /**
     * 专利号
     */
    @Excel(name = "专利号")
    private String patentNo;

    /**
     * 材质描述
     */
    @Excel(name = "材质描述")
    private String materialDesc;

    /**
     * ship to id
     */
    @Excel(name = "ship to id")
    private String shipToId;

    /**
     * 条码
     */
    @Excel(name = "条码")
    private String barCode;

    /**
     * 印刷方向
     */
    @Excel(name = "印刷方向")
    private String printingDirection;

}
