package com.ximai.mes.md.service.impl;

import java.util.List;

import cn.hutool.core.collection.CollUtil;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.utils.data.DateUtils;
import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ximai.mes.md.domain.MdSapField;
import com.ximai.mes.md.mapper.MdSapFieldMapper;
import com.ximai.mes.md.service.IMdSapFieldService;
import com.ximai.mes.md.vo.SapFieldVo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Map;

/**
 * Sap特性视图Service业务层处理
 *
 * @author generator
 * @date 2024-01-31
 */
@Service
@AllArgsConstructor
public class MdSapFieldServiceImpl extends ServiceImpl<MdSapFieldMapper, MdSapField> implements IMdSapFieldService {


    @Override
    public TableDataInfo page(Map<String, Object> params) {
        final Integer current = MapUtil.getInt(params, "current");
        final Integer size = MapUtil.getInt(params, "size");
        params.put("offset", (current - 1) * size);
        final Integer total = baseMapper.countByMap(params);
        return new TableDataInfo(baseMapper.listByMap(params), total);
    }

    @Override
    public MdSapField getOne(Map<String, Object> params) {
        final List<MdSapField> viewList = baseMapper.listByMap(params);
        return CollUtil.isNotEmpty(viewList) ? viewList.get(0) : null;
    }

    @Override
    public List<MdSapField> selectList(Map<String, Object> params) {
        return baseMapper.listByMap(params);
    }

    @Override
    public List<SapFieldVo> listVo(Map<String, Object> params) {
        return baseMapper.listVoByParentId(params);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean insert(MdSapField mdSapField) {
        mdSapField.setCreateTime(DateUtils.getNowDate());
        Boolean save = save(mdSapField);

        if (MdSapField.DataType.objOrArr().contains(mdSapField.getDataType())) {
           return baseMapper.updateParentIdByIds(mdSapField);
        }
        return save;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean update(MdSapField mdSapField) {
        mdSapField.setUpdateTime(DateUtils.getNowDate());
        if (MdSapField.DataType.objOrArr().contains(mdSapField.getDataType())) {
            return baseMapper.updateParentIdByIds(mdSapField);
        }
        return updateById(mdSapField);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteByIds(List<Long> ids) {
        return removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteById(Long id) {
        return removeById(id);
    }

}
