package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSalesShipmentPointMapper;
import com.ximai.mes.md.domain.MdSalesShipmentPoint;
import com.ximai.mes.md.service.IMdSalesShipmentPointService;

/**
 * 销售订单装运点Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSalesShipmentPointServiceImpl implements IMdSalesShipmentPointService
{
    @Autowired
    private MdSalesShipmentPointMapper mdSalesShipmentPointMapper;

    /**
     * 查询销售订单装运点
     *
     * @param id 销售订单装运点主键
     * @return 销售订单装运点
     */
    @Override
    public MdSalesShipmentPoint selectMdSalesShipmentPointById(String id)
    {
        return mdSalesShipmentPointMapper.selectMdSalesShipmentPointById(id);
    }

    /**
     * 查询销售订单装运点列表
     *
     * @param mdSalesShipmentPoint 销售订单装运点
     * @return 销售订单装运点
     */
    @Override
    public List<MdSalesShipmentPoint> selectMdSalesShipmentPointList(MdSalesShipmentPoint mdSalesShipmentPoint)
    {
        return mdSalesShipmentPointMapper.selectMdSalesShipmentPointList(mdSalesShipmentPoint);
    }

    /**
     * 新增销售订单装运点
     *
     * @param mdSalesShipmentPoint 销售订单装运点
     * @return 结果
     */
    @Override
    public int insertMdSalesShipmentPoint(MdSalesShipmentPoint mdSalesShipmentPoint)
    {
        mdSalesShipmentPoint.setCreateTime(DateUtils.getNowDate());
        return mdSalesShipmentPointMapper.insertMdSalesShipmentPoint(mdSalesShipmentPoint);
    }

    /**
     * 修改销售订单装运点
     *
     * @param mdSalesShipmentPoint 销售订单装运点
     * @return 结果
     */
    @Override
    public int updateMdSalesShipmentPoint(MdSalesShipmentPoint mdSalesShipmentPoint)
    {
        mdSalesShipmentPoint.setUpdateTime(DateUtils.getNowDate());
        return mdSalesShipmentPointMapper.updateMdSalesShipmentPoint(mdSalesShipmentPoint);
    }

    /**
     * 批量删除销售订单装运点
     *
     * @param ids 需要删除的销售订单装运点主键
     * @return 结果
     */
    @Override
    public int deleteMdSalesShipmentPointByIds(String[] ids)
    {
        return mdSalesShipmentPointMapper.deleteMdSalesShipmentPointByIds(ids);
    }

    /**
     * 删除销售订单装运点信息
     *
     * @param id 销售订单装运点主键
     * @return 结果
     */
    @Override
    public int deleteMdSalesShipmentPointById(String id)
    {
        return mdSalesShipmentPointMapper.deleteMdSalesShipmentPointById(id);
    }
}
