package com.ximai.mes.md.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSaleOrderOfficeMapper;
import com.ximai.mes.md.domain.MdSaleOrderOffice;
import com.ximai.mes.md.service.IMdSaleOrderOfficeService;

/**
 * 销售订单办事处Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSaleOrderOfficeServiceImpl implements IMdSaleOrderOfficeService
{
    @Autowired
    private MdSaleOrderOfficeMapper mdSaleOrderOfficeMapper;

    /**
     * 查询销售订单办事处
     *
     * @param id 销售订单办事处主键
     * @return 销售订单办事处
     */
    @Override
    public MdSaleOrderOffice selectMdSaleOrderOfficeById(Long id)
    {
        return mdSaleOrderOfficeMapper.selectMdSaleOrderOfficeById(id);
    }

    /**
     * 查询销售订单办事处列表
     *
     * @param mdSaleOrderOffice 销售订单办事处
     * @return 销售订单办事处
     */
    @Override
    public List<MdSaleOrderOffice> selectMdSaleOrderOfficeList(MdSaleOrderOffice mdSaleOrderOffice)
    {
        return mdSaleOrderOfficeMapper.selectMdSaleOrderOfficeList(mdSaleOrderOffice);
    }

    /**
     * 新增销售订单办事处
     *
     * @param mdSaleOrderOffice 销售订单办事处
     * @return 结果
     */
    @Override
    public int insertMdSaleOrderOffice(MdSaleOrderOffice mdSaleOrderOffice)
    {
        return mdSaleOrderOfficeMapper.insertMdSaleOrderOffice(mdSaleOrderOffice);
    }

    /**
     * 修改销售订单办事处
     *
     * @param mdSaleOrderOffice 销售订单办事处
     * @return 结果
     */
    @Override
    public int updateMdSaleOrderOffice(MdSaleOrderOffice mdSaleOrderOffice)
    {
        return mdSaleOrderOfficeMapper.updateMdSaleOrderOffice(mdSaleOrderOffice);
    }

    /**
     * 批量删除销售订单办事处
     *
     * @param ids 需要删除的销售订单办事处主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleOrderOfficeByIds(Long[] ids)
    {
        return mdSaleOrderOfficeMapper.deleteMdSaleOrderOfficeByIds(ids);
    }

    /**
     * 删除销售订单办事处信息
     *
     * @param id 销售订单办事处主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleOrderOfficeById(Long id)
    {
        return mdSaleOrderOfficeMapper.deleteMdSaleOrderOfficeById(id);
    }
}
