package com.ximai.mes.md.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSaleOrderChannelMapper;
import com.ximai.mes.md.domain.MdSaleOrderChannel;
import com.ximai.mes.md.service.IMdSaleOrderChannelService;

/**
 * 销售订单分销渠道Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSaleOrderChannelServiceImpl implements IMdSaleOrderChannelService
{
    @Autowired
    private MdSaleOrderChannelMapper mdSaleOrderChannelMapper;

    /**
     * 查询销售订单分销渠道
     *
     * @param id 销售订单分销渠道主键
     * @return 销售订单分销渠道
     */
    @Override
    public MdSaleOrderChannel selectMdSaleOrderChannelById(Long id)
    {
        return mdSaleOrderChannelMapper.selectMdSaleOrderChannelById(id);
    }

    /**
     * 查询销售订单分销渠道列表
     *
     * @param mdSaleOrderChannel 销售订单分销渠道
     * @return 销售订单分销渠道
     */
    @Override
    public List<MdSaleOrderChannel> selectMdSaleOrderChannelList(MdSaleOrderChannel mdSaleOrderChannel)
    {
        return mdSaleOrderChannelMapper.selectMdSaleOrderChannelList(mdSaleOrderChannel);
    }

    /**
     * 新增销售订单分销渠道
     *
     * @param mdSaleOrderChannel 销售订单分销渠道
     * @return 结果
     */
    @Override
    public int insertMdSaleOrderChannel(MdSaleOrderChannel mdSaleOrderChannel)
    {
        return mdSaleOrderChannelMapper.insertMdSaleOrderChannel(mdSaleOrderChannel);
    }

    /**
     * 修改销售订单分销渠道
     *
     * @param mdSaleOrderChannel 销售订单分销渠道
     * @return 结果
     */
    @Override
    public int updateMdSaleOrderChannel(MdSaleOrderChannel mdSaleOrderChannel)
    {
        return mdSaleOrderChannelMapper.updateMdSaleOrderChannel(mdSaleOrderChannel);
    }

    /**
     * 批量删除销售订单分销渠道
     *
     * @param ids 需要删除的销售订单分销渠道主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleOrderChannelByIds(Long[] ids)
    {
        return mdSaleOrderChannelMapper.deleteMdSaleOrderChannelByIds(ids);
    }

    /**
     * 删除销售订单分销渠道信息
     *
     * @param id 销售订单分销渠道主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleOrderChannelById(Long id)
    {
        return mdSaleOrderChannelMapper.deleteMdSaleOrderChannelById(id);
    }
}
