package com.ximai.mes.md.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdProductSpecMapper;
import com.ximai.mes.md.domain.MdProductSpec;
import com.ximai.mes.md.service.IMdProductSpecService;

/**
 * 产品特性名称Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@Service
public class MdProductSpecServiceImpl implements IMdProductSpecService
{
    @Autowired
    private MdProductSpecMapper mdProductSpecMapper;

    /**
     * 查询产品特性名称
     *
     * @param itemSpecId 产品特性名称主键
     * @return 产品特性名称
     */
    @Override
    public MdProductSpec selectMdItemSpecByItemSpecId(Long itemSpecId)
    {
        return mdProductSpecMapper.selectMdItemSpecByItemSpecId(itemSpecId);
    }

    /**
     * 查询产品特性名称列表
     *
     * @param mdProductSpec 产品特性名称
     * @return 产品特性名称
     */
    @Override
    public List<MdProductSpec> selectMdItemSpecList(MdProductSpec mdProductSpec)
    {
        return mdProductSpecMapper.selectMdItemSpecList(mdProductSpec);
    }

    /**
     * 新增产品特性名称
     *
     * @param mdProductSpec 产品特性名称
     * @return 结果
     */
    @Override
    public int insertMdItemSpec(MdProductSpec mdProductSpec)
    {
        return mdProductSpecMapper.insertMdItemSpec(mdProductSpec);
    }

    /**
     * 修改产品特性名称
     *
     * @param mdProductSpec 产品特性名称
     * @return 结果
     */
    @Override
    public int updateMdItemSpec(MdProductSpec mdProductSpec)
    {
        return mdProductSpecMapper.updateMdItemSpec(mdProductSpec);
    }

    /**
     * 批量删除产品特性名称
     *
     * @param itemSpecIds 需要删除的产品特性名称主键
     * @return 结果
     */
    @Override
    public int deleteMdItemSpecByItemSpecIds(Long[] itemSpecIds)
    {
        return mdProductSpecMapper.deleteMdItemSpecByItemSpecIds(itemSpecIds);
    }

    /**
     * 删除产品特性名称信息
     *
     * @param itemSpecId 产品特性名称主键
     * @return 结果
     */
    @Override
    public int deleteMdItemSpecByItemSpecId(Long itemSpecId)
    {
        return mdProductSpecMapper.deleteMdItemSpecByItemSpecId(itemSpecId);
    }
}
