package com.ximai.mes.md.service.impl;

import java.util.List;

import com.ximai.mes.md.vo.MdProductLossVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdProductLossMapper;
import com.ximai.mes.md.domain.MdProductLoss;
import com.ximai.mes.md.service.IMdProductLossService;

/**
 * 产品loss配置Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@Service
public class MdProductLossServiceImpl implements IMdProductLossService
{
    @Autowired
    private MdProductLossMapper mdProductLossMapper;

    /**
     * 查询产品loss配置
     *
     * @param productLossId 产品loss配置主键
     * @return 产品loss配置
     */
    @Override
    public MdProductLossVo selectMdProductLossByProductLossId(Long productLossId)
    {
        return mdProductLossMapper.selectMdProductLossByProductLossId(productLossId);
    }

    /**
     * 查询产品loss配置列表
     *
     * @param mdProductLoss 产品loss配置
     * @return 产品loss配置
     */
    @Override
    public List<MdProductLossVo> selectMdProductLossList(MdProductLoss mdProductLoss)
    {
        return mdProductLossMapper.selectMdProductLossList(mdProductLoss);
    }

    /**
     * 新增产品loss配置
     *
     * @param mdProductLoss 产品loss配置
     * @return 结果
     */
    @Override
    public int insertMdProductLoss(MdProductLoss mdProductLoss)
    {
        return mdProductLossMapper.insertMdProductLoss(mdProductLoss);
    }

    /**
     * 修改产品loss配置
     *
     * @param mdProductLoss 产品loss配置
     * @return 结果
     */
    @Override
    public int updateMdProductLoss(MdProductLoss mdProductLoss)
    {
        return mdProductLossMapper.updateMdProductLoss(mdProductLoss);
    }

    /**
     * 批量删除产品loss配置
     *
     * @param productLossIds 需要删除的产品loss配置主键
     * @return 结果
     */
    @Override
    public int deleteMdProductLossByProductLossIds(Long[] productLossIds)
    {
        return mdProductLossMapper.deleteMdProductLossByProductLossIds(productLossIds);
    }

    /**
     * 删除产品loss配置信息
     *
     * @param productLossId 产品loss配置主键
     * @return 结果
     */
    @Override
    public int deleteMdProductLossByProductLossId(Long productLossId)
    {
        return mdProductLossMapper.deleteMdProductLossByProductLossId(productLossId);
    }
}
