package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdProductLookMapper;
import com.ximai.mes.md.domain.MdProductLook;
import com.ximai.mes.md.service.IMdProductLookService;

/**
 * 产品外观Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@Service
public class MdProductLookServiceImpl implements IMdProductLookService
{
    @Autowired
    private MdProductLookMapper mdProductLookMapper;

    /**
     * 查询产品外观
     *
     * @param itemId 产品外观主键
     * @return 产品外观
     */
    @Override
    public MdProductLook selectMdProductLookByItemId(Long itemId)
    {
        return mdProductLookMapper.selectMdProductLookByItemId(itemId);
    }

    /**
     * 查询产品外观列表
     *
     * @param mdProductLook 产品外观
     * @return 产品外观
     */
    @Override
    public List<MdProductLook> selectMdProductLookList(MdProductLook mdProductLook)
    {
        return mdProductLookMapper.selectMdProductLookList(mdProductLook);
    }

    /**
     * 新增产品外观
     *
     * @param mdProductLook 产品外观
     * @return 结果
     */
    @Override
    public int insertMdProductLook(MdProductLook mdProductLook)
    {
        mdProductLook.setCreateTime(DateUtils.getNowDate());
        return mdProductLookMapper.insertMdProductLook(mdProductLook);
    }

    /**
     * 修改产品外观
     *
     * @param mdProductLook 产品外观
     * @return 结果
     */
    @Override
    public int updateMdProductLook(MdProductLook mdProductLook)
    {
        mdProductLook.setUpdateTime(DateUtils.getNowDate());
        return mdProductLookMapper.updateMdProductLook(mdProductLook);
    }

    /**
     * 批量删除产品外观
     *
     * @param itemIds 需要删除的产品外观主键
     * @return 结果
     */
    @Override
    public int deleteMdProductLookByItemIds(Long[] itemIds)
    {
        return mdProductLookMapper.deleteMdProductLookByItemIds(itemIds);
    }

    /**
     * 删除产品外观信息
     *
     * @param itemId 产品外观主键
     * @return 结果
     */
    @Override
    public int deleteMdProductLookByItemId(Long itemId)
    {
        return mdProductLookMapper.deleteMdProductLookByItemId(itemId);
    }
}
