package com.ximai.mes.md.service.impl;

import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.md.domain.MdClientPaymentRelation;
import com.ximai.mes.md.mapper.MdClientPaymentRelationMapper;
import com.ximai.mes.md.service.IMdClientPaymentRelationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 客户付款信息关联Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
@Service
public class MdClientPaymentRelationServiceImpl implements IMdClientPaymentRelationService {
    @Autowired
    private MdClientPaymentRelationMapper mdClientPaymentRelationMapper;

    /**
     * 查询客户付款信息关联
     *
     * @param id 客户付款信息关联主键
     * @return 客户付款信息关联
     */
    @Override
    public MdClientPaymentRelation selectMdClientPaymentRelationById(String id) {
        return mdClientPaymentRelationMapper.selectMdClientPaymentRelationById(id);
    }

    /**
     * 查询客户付款信息关联列表
     *
     * @param mdClientPaymentRelation 客户付款信息关联
     * @return 客户付款信息关联
     */
    @Override
    public List<MdClientPaymentRelation> selectMdClientPaymentRelationList(MdClientPaymentRelation mdClientPaymentRelation) {
        return mdClientPaymentRelationMapper.selectMdClientPaymentRelationList(mdClientPaymentRelation);
    }

    /**
     * 新增客户付款信息关联
     *
     * @param mdClientPaymentRelation 客户付款信息关联
     * @return 结果
     */
    @Override
    public int insertMdClientPaymentRelation(MdClientPaymentRelation mdClientPaymentRelation) {
        mdClientPaymentRelation.setCreateTime(DateUtils.getNowDate());
        return mdClientPaymentRelationMapper.insertMdClientPaymentRelation(mdClientPaymentRelation);
    }

    /**
     * 修改客户付款信息关联
     *
     * @param mdClientPaymentRelation 客户付款信息关联
     * @return 结果
     */
    @Override
    public int updateMdClientPaymentRelation(MdClientPaymentRelation mdClientPaymentRelation) {
        mdClientPaymentRelation.setUpdateTime(DateUtils.getNowDate());
        return mdClientPaymentRelationMapper.updateMdClientPaymentRelation(mdClientPaymentRelation);
    }

    /**
     * 批量删除客户付款信息关联
     *
     * @param ids 需要删除的客户付款信息关联主键
     * @return 结果
     */
    @Override
    public int deleteMdClientPaymentRelationByIds(String[] ids) {
        return mdClientPaymentRelationMapper.deleteMdClientPaymentRelationByIds(ids);
    }

    /**
     * 删除客户付款信息关联信息
     *
     * @param id 客户付款信息关联主键
     * @return 结果
     */
    @Override
    public int deleteMdClientPaymentRelationById(String id) {
        return mdClientPaymentRelationMapper.deleteMdClientPaymentRelationById(id);
    }
}
