package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdBrandContactMapper;
import com.ximai.mes.md.domain.MdBrandContact;
import com.ximai.mes.md.service.IMdBrandContactService;

/**
 * 品牌联系人Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@Service
public class MdBrandContactServiceImpl implements IMdBrandContactService
{
    @Autowired
    private MdBrandContactMapper mdBrandContactMapper;

    /**
     * 查询品牌联系人
     *
     * @param brandContactId 品牌联系人主键
     * @return 品牌联系人
     */
    @Override
    public MdBrandContact selectMdBrandContactByBrandContactId(Long brandContactId)
    {
        return mdBrandContactMapper.selectMdBrandContactByBrandContactId(brandContactId);
    }

    /**
     * 查询品牌联系人列表
     *
     * @param mdBrandContact 品牌联系人
     * @return 品牌联系人
     */
    @Override
    public List<MdBrandContact> selectMdBrandContactList(MdBrandContact mdBrandContact)
    {
        return mdBrandContactMapper.selectMdBrandContactList(mdBrandContact);
    }

    /**
     * 新增品牌联系人
     *
     * @param mdBrandContact 品牌联系人
     * @return 结果
     */
    @Override
    public int insertMdBrandContact(MdBrandContact mdBrandContact)
    {
        mdBrandContact.setCreateTime(DateUtils.getNowDate());
        return mdBrandContactMapper.insertMdBrandContact(mdBrandContact);
    }

    /**
     * 修改品牌联系人
     *
     * @param mdBrandContact 品牌联系人
     * @return 结果
     */
    @Override
    public int updateMdBrandContact(MdBrandContact mdBrandContact)
    {
        mdBrandContact.setUpdateTime(DateUtils.getNowDate());
        return mdBrandContactMapper.updateMdBrandContact(mdBrandContact);
    }

    /**
     * 批量删除品牌联系人
     *
     * @param brandContactIds 需要删除的品牌联系人主键
     * @return 结果
     */
    @Override
    public int deleteMdBrandContactByBrandContactIds(Long[] brandContactIds)
    {
        return mdBrandContactMapper.deleteMdBrandContactByBrandContactIds(brandContactIds);
    }

    /**
     * 删除品牌联系人信息
     *
     * @param brandContactId 品牌联系人主键
     * @return 结果
     */
    @Override
    public int deleteMdBrandContactByBrandContactId(Long brandContactId)
    {
        return mdBrandContactMapper.deleteMdBrandContactByBrandContactId(brandContactId);
    }
}
