package com.ximai.mes.md.service.impl;


import com.ximai.mes.md.vo.MdBaseInfoVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdBaseInfoMapper;
import com.ximai.mes.md.domain.MdBaseInfo;
import com.ximai.mes.md.service.IMdBaseInfoService;

/**
 * 产品基本信息Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@Service
public class MdBaseInfoServiceImpl implements IMdBaseInfoService
{
    @Autowired
    private MdBaseInfoMapper mdBaseInfoMapper;

    /**
     * 查询产品基本信息
     *
     * @param itemId 产品基本信息主键
     * @return 产品基本信息
     */
    @Override
    public MdBaseInfoVo selectMdBaseInfoByItemId(Long itemId)
    {
        return mdBaseInfoMapper.selectMdBaseInfoByItemId(itemId);
    }

    /**
     * 新增产品基本信息
     *
     * @param mdBaseInfo 产品基本信息
     * @return 结果
     */
    @Override
    public int insertMdBaseInfo(MdBaseInfo mdBaseInfo)
    {
        return mdBaseInfoMapper.insertMdBaseInfo(mdBaseInfo);
    }

    /**
     * 修改产品基本信息
     *
     * @param mdBaseInfo 产品基本信息
     * @return 结果
     */
    @Override
    public int updateMdBaseInfo(MdBaseInfo mdBaseInfo)
    {
        return mdBaseInfoMapper.updateMdBaseInfo(mdBaseInfo);
    }


    /**
     * 删除产品基本信息信息
     *
     * @param itemId 产品基本信息主键
     * @return 结果
     */
    @Override
    public int deleteMdBaseInfoByItemId(Long itemId)
    {
        return mdBaseInfoMapper.deleteMdBaseInfoByItemId(itemId);
    }
}
