package com.ximai.mes.md.service;

import com.ximai.mes.md.domain.MdFaceColor;
import com.ximai.mes.md.vo.MdFaceColorVo;

import java.util.List;

/**
* @author 16508
* @description 针对表【md_face_color(产品版面颜色)】的数据库操作Service
* @createDate 2024-01-15 19:08:20
*/
public interface MdFaceColorService {

    /**
     * 查询产品颜色
     * @param FaceColor
     * @return
     */
    public MdFaceColorVo selectMdFaceColorByFaceColorId(Long FaceColor);

    /**
     * 查询产品颜色列表
     * @param faceColor
     * @return
     */
    public List<MdFaceColorVo> selectMdFaceColorList(MdFaceColor faceColor);

    /**
     * 新增产品颜色关系
     * @param mdFaceColor
     * @return
     */
    public int insertMdFaceColor(MdFaceColor mdFaceColor);

    /**
     * 修改产品颜色关系
     * @param mdFaceColor
     * @return
     */
    public int updateMdFaceColor(MdFaceColor mdFaceColor);

    /**
     * 批量删除产品颜色
     * @param faceColorIds
     * @return
     */
    public int deleteMdFaceColorByFaceColorIds(Long[] faceColorIds);

    String checkMdFaceColorUnique(MdFaceColor mdFaceColor);
}
