package com.ximai.mes.md.service;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import com.ximai.mes.md.domain.MdVendor;

/**
 * 供应商Service接口
 *
 * @date 2022-05-06
 */
public interface IMdVendorService
{
    /**
     * 查询供应商
     *
     * @param vendorId 供应商主键
     * @return 供应商
     */
    public MdVendor selectMdVendorByVendorId(Long vendorId);

    /**
     * 查询供应商列表
     *
     * @param mdVendor 供应商
     * @return 供应商集合
     */
    public List<MdVendor> selectMdVendorList(MdVendor mdVendor);

    public String checkVendorCodeUnique(MdVendor mdVendor);
    public String checkVendorNameUnique(MdVendor mdVendor);
    public String checkVendorNickUnique(MdVendor mdVendor);

    /**
     * 导入供应商信息
     * @param inputStream
     * @return
     */
    public void importVendor(InputStream inputStream, Boolean isUpdateSupport);

    /**
     * 新增供应商
     *
     * @param mdVendor 供应商
     * @return 结果
     */
    public int insertMdVendor(MdVendor mdVendor);

    /**
     * 修改供应商
     *
     * @param mdVendor 供应商
     * @return 结果
     */
    public int updateMdVendor(MdVendor mdVendor);

    /**
     * 批量删除供应商
     *
     * @param vendorIds 需要删除的供应商主键集合
     * @return 结果
     */
    public int deleteMdVendorByVendorIds(Long[] vendorIds);

    /**
     * 删除供应商信息
     *
     * @param vendorId 供应商主键
     * @return 结果
     */
    public int deleteMdVendorByVendorId(Long vendorId);

    /**
     * 同步ERP供应商信息
     *
     */
    public void syncErpData();
}
