package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdVehicleDispatch;

/**
 * 派车记录Service接口
 *
 * @author generator
 * @date 2024-01-25
 */
public interface IMdVehicleDispatchService
{
    /**
     * 查询派车记录
     *
     * @param dispatchId 派车记录主键
     * @return 派车记录
     */
    public MdVehicleDispatch selectMdVehicleDispatchByDispatchId(Long dispatchId);

    /**
     * 查询派车记录列表
     *
     * @param mdVehicleDispatch 派车记录
     * @return 派车记录集合
     */
    public List<MdVehicleDispatch> selectMdVehicleDispatchList(MdVehicleDispatch mdVehicleDispatch);

    /**
     * 新增派车记录
     *
     * @param mdVehicleDispatch 派车记录
     * @return 结果
     */
    public int insertMdVehicleDispatch(MdVehicleDispatch mdVehicleDispatch);

    /**
     * 修改派车记录
     *
     * @param mdVehicleDispatch 派车记录
     * @return 结果
     */
    public int updateMdVehicleDispatch(MdVehicleDispatch mdVehicleDispatch);

    /**
     * 批量删除派车记录
     *
     * @param dispatchIds 需要删除的派车记录主键集合
     * @return 结果
     */
    public int deleteMdVehicleDispatchByDispatchIds(Long[] dispatchIds);

    /**
     * 删除派车记录信息
     *
     * @param dispatchId 派车记录主键
     * @return 结果
     */
    public int deleteMdVehicleDispatchByDispatchId(Long dispatchId);
}
