package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdSalesCurrency;

/**
 * 订单 交易币别Service接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface IMdSalesCurrencyService
{
    /**
     * 查询订单 交易币别
     *
     * @param id 订单 交易币别主键
     * @return 订单 交易币别
     */
    public MdSalesCurrency selectMdSalesCurrencyById(String id);

    /**
     * 查询订单 交易币别列表
     *
     * @param mdSalesCurrency 订单 交易币别
     * @return 订单 交易币别集合
     */
    public List<MdSalesCurrency> selectMdSalesCurrencyList(MdSalesCurrency mdSalesCurrency);

    /**
     * 新增订单 交易币别
     *
     * @param mdSalesCurrency 订单 交易币别
     * @return 结果
     */
    public int insertMdSalesCurrency(MdSalesCurrency mdSalesCurrency);

    /**
     * 修改订单 交易币别
     *
     * @param mdSalesCurrency 订单 交易币别
     * @return 结果
     */
    public int updateMdSalesCurrency(MdSalesCurrency mdSalesCurrency);

    /**
     * 批量删除订单 交易币别
     *
     * @param ids 需要删除的订单 交易币别主键集合
     * @return 结果
     */
    public int deleteMdSalesCurrencyByIds(String[] ids);

    /**
     * 删除订单 交易币别信息
     *
     * @param id 订单 交易币别主键
     * @return 结果
     */
    public int deleteMdSalesCurrencyById(String id);
}
