package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdSaleOrderOrg;

/**
 * 销售订单组织Service接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface IMdSaleOrderOrgService
{
    /**
     * 查询销售订单组织
     *
     * @param id 销售订单组织主键
     * @return 销售订单组织
     */
    public MdSaleOrderOrg selectMdSaleOrderOrgById(Long id);

    /**
     * 查询销售订单组织列表
     *
     * @param mdSaleOrderOrg 销售订单组织
     * @return 销售订单组织集合
     */
    public List<MdSaleOrderOrg> selectMdSaleOrderOrgList(MdSaleOrderOrg mdSaleOrderOrg);

    /**
     * 新增销售订单组织
     *
     * @param mdSaleOrderOrg 销售订单组织
     * @return 结果
     */
    public int insertMdSaleOrderOrg(MdSaleOrderOrg mdSaleOrderOrg);

    /**
     * 修改销售订单组织
     *
     * @param mdSaleOrderOrg 销售订单组织
     * @return 结果
     */
    public int updateMdSaleOrderOrg(MdSaleOrderOrg mdSaleOrderOrg);

    /**
     * 批量删除销售订单组织
     *
     * @param ids 需要删除的销售订单组织主键集合
     * @return 结果
     */
    public int deleteMdSaleOrderOrgByIds(Long[] ids);

    /**
     * 删除销售订单组织信息
     *
     * @param id 销售订单组织主键
     * @return 结果
     */
    public int deleteMdSaleOrderOrgById(Long id);
}
