package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdFactory;

/**
 * 工厂Service接口
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public interface IMdFactoryService
{
    /**
     * 查询工厂
     *
     * @param factoryId 工厂主键
     * @return 工厂
     */
    public MdFactory selectMdFactoryByFactoryId(Long factoryId);

    /**
     * 查询工厂列表
     *
     * @param mdFactory 工厂
     * @return 工厂集合
     */
    public List<MdFactory> selectMdFactoryList(MdFactory mdFactory);

    /**
     * 新增工厂
     *
     * @param mdFactory 工厂
     * @return 结果
     */
    public int insertMdFactory(MdFactory mdFactory);

    /**
     * 修改工厂
     *
     * @param mdFactory 工厂
     * @return 结果
     */
    public int updateMdFactory(MdFactory mdFactory);

    /**
     * 批量删除工厂
     *
     * @param factoryIds 需要删除的工厂主键集合
     * @return 结果
     */
    public int deleteMdFactoryByFactoryIds(Long[] factoryIds);

    /**
     * 删除工厂信息
     *
     * @param factoryId 工厂主键
     * @return 结果
     */
    public int deleteMdFactoryByFactoryId(Long factoryId);
}
