package com.ximai.mes.md.mapper;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.md.domain.MdVehicle;

/**
 * 车辆列表Mapper接口
 *
 * @author generator
 * @date 2024-01-25
 */
public interface MdVehicleMapper extends BaseMapper<MdVehicle>
{
    /**
     * 查询车辆列表
     *
     * @param vehicleId 车辆列表主键
     * @return 车辆列表
     */
    public MdVehicle selectMdVehicleByVehicleId(Long vehicleId);

    /**
     * 查询车辆列表列表
     *
     * @param mdVehicle 车辆列表
     * @return 车辆列表集合
     */
    public List<MdVehicle> selectMdVehicleList(MdVehicle mdVehicle);

    /**
     * 新增车辆列表
     *
     * @param mdVehicle 车辆列表
     * @return 结果
     */
    public int insertMdVehicle(MdVehicle mdVehicle);

    /**
     * 修改车辆列表
     *
     * @param mdVehicle 车辆列表
     * @return 结果
     */
    public int updateMdVehicle(MdVehicle mdVehicle);

    /**
     * 删除车辆列表
     *
     * @param vehicleId 车辆列表主键
     * @return 结果
     */
    public int deleteMdVehicleByVehicleId(Long vehicleId);

    /**
     * 批量删除车辆列表
     *
     * @param vehicleIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdVehicleByVehicleIds(Long[] vehicleIds);
}
