package com.ximai.mes.md.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.common.utils.excel.converter.DictionaryConverter;
import com.ximai.common.utils.excel.converter.DictionaryFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 工作单元对象 md_workunit
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
@Data
@ApiModel("工作单元")
@AllArgsConstructor
@NoArgsConstructor
public class MdWorkunitExcelExport {
    /**
     * 工作站名称
     */
    @ExcelProperty("工作站名称")
    private String workstationName;

    /**
     * 工作站编码
     */
    @ExcelProperty("工作站编码")
    private String workstationCode;

    /**
     * 工作单元编码
     */
    @ExcelProperty("工作单元编码")
    private String workunitCode;

    /**
     * 工作单元名称
     */
    @ExcelProperty("工作单元名称")
    private String workunitName;

    /**
     * 是否故障
     */
    @ExcelProperty(value = "是否故障", converter = DictionaryConverter.class)
    @DictionaryFormat(dictType = "sys_yes_no")
    private String faultFlag;

    /**
     * 是否启用
     */
    @ExcelProperty(value="是否启用", converter = DictionaryConverter.class)
    @DictionaryFormat(dictType = "sys_yes_no")
    private String enableFlag;

    @ExcelProperty(value="备注")
    private String remark;

}
