package com.ximai.mes.md.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 工作站对象 md_workstation
 *
 * @date 2022-05-10
 */
@Data
@ApiModel("工作站")
@AllArgsConstructor
@NoArgsConstructor
public class MdWorkstationExcelExport {
    private static final long serialVersionUID = 1L;

    /**
     * 工作中心编码
     */
    @ExcelProperty("工作中心编码")
    @ApiModelProperty("工作中心编码")
    private String workstationCode;

    /**
     * 工作中心名称
     */
    @ExcelProperty("工作中心名称")
    @ApiModelProperty("工作中心名称")
    private String workstationName;

    /**
     * 工作中心类别
     */
    @ExcelProperty("工作中心类别")
    @ApiModelProperty("工作中心类别")
    private String workstationType;

    /**
     * 工厂编号
     */
    @ExcelProperty("工厂编号")
    private String factoryCode;


    @ExcelProperty("车间名称")
    @ApiModelProperty("车间名称")
    private String workshopName;


}
