package com.ximai.mes.md.dto;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.annotation.ExcelProperty;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.net.URLEncoder;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Optional;

/**
 * 客户对象 md_client
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
@Data
public class MdClientExcelImport {

    /**
     * 客户编码
     */
    @ExcelProperty("客户编码")
    private String clientCode;

    /**
     * sap客户编码
     */
    @ExcelProperty("sap客户编码")
    private String sapClientCode;

    /**
     * 客户名称
     */
    @ExcelProperty("客户名称")
    private String clientName;

    /**
     * 客户简称
     */
    @ExcelProperty("客户简称")
    private String clientNick;

    /**
     * 客户英文名称
     */
    @ExcelProperty("客户英文名称")
    private String clientEn;

    /**
     * 英文名简称
     */
    @ExcelProperty("英文名简称")
    private String clientEnAbbr;

    /**
     * 客户等级
     */
    @ExcelProperty("客户等级")
    private Long clientLevel;

    public static void main(String[] args) throws Exception {
        FileOutputStream response = new FileOutputStream("C:\\Users\\men_c\\Desktop\\test.xlsx");
        String sheetName = "Sheet1";
        EasyExcel.write(response, MdClientExcelImport.class)
                .sheet(sheetName).doWrite(new ArrayList<>());
        response.close();
    }

}
