package com.ximai.mes.md.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 工作站对象 md_workstation
 *
 * @date 2022-05-10
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MdWorkstation extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 工作中心ID
     */
    @TableId(type = IdType.AUTO)
    private Long workstationId;

    /**
     * 工作中心编码
     */
    @Excel(name = "工作中心编码")
    @ApiModelProperty("工作中心编码")
    private String workstationCode;

    /**
     * 工作中心名称
     */
    @Excel(name = "工作中心名称")
    @ApiModelProperty("工作中心名称")
    private String workstationName;

    /**
     * 工作中心类别
     */
    @Excel(name = "工作中心类别")
    @ApiModelProperty("工作中心类别")
    private String workstationType;

    /**
     * 工厂编号
     */
    @Excel(name = "工厂编号")
    private String factoryCode;

    /**
     * 工作中心用途
     */
    @Excel(name = "工作中心用途")
    private String usageCode;

    /**
     * 车间ID
     */
    @Excel(name = "车间ID")
    @ApiModelProperty("车间ID")
    private Long workshopId;

    private String workshopName;

    private String workshopCode;
    /**
     * 工序ID
     */
    @Excel(name = "工序ID")
    private Long processId;

    private String processName;

    private String processCode;

    /**
     * 工作中心负责人
     */
    @Excel(name = "工作中心负责人")
    private String responsiblePerson;

    private String nickName;

    /**
     * 标准工时
     */
    @Excel(name = "标准工时")
    @ApiModelProperty("标准工时")
    private Long stdWorkingTime;

    /**
     * 标准值码
     */
    @Excel(name = "标准值码")
    @ApiModelProperty("标准值码")
    private String standardValueCode;

    /**
     * 加工方式
     */
    @Excel(name = "加工方式")
    @ApiModelProperty("加工方式")
    private String processingMethod;

    /**
     * 成本中心
     */
    @Excel(name = "成本中心")
    @ApiModelProperty("成本中心")
    private String costCenterCode;

    /**
     * 是否倒冲
     */
    @Excel(name = "是否倒冲")
    @ApiModelProperty("是否倒冲")
    private String isBackflush;

    /**
     * 看机人数
     */
    @Excel(name = "看机人数")
    @ApiModelProperty("看机人数")
    private BigDecimal watchingAircraftNum;

    /**
     * 是否启用
     */
    @Excel(name = "是否启用")
    private String enableFlag;

    /**
     * 工作单元编码
     */
    @TableField(exist = false)
    private String workunitCode;

    /**
     * 转间配送时间
     */
    @Excel(name = "转间配送时间")
    private BigDecimal transferTime;

}
