package com.ximai.mes.md.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

import javax.validation.constraints.NotBlank;

/**
 * 尺码组对象 md_size_group
 *
 * @author yinjinlu
 * @date 2024-01-18
 */
public class MdSizeGroup extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 尺码组id */
    private Long sizeGroupId;

    /** 尺码组编码 */
    @Excel(name = "尺码组编码")
    private String sizeGroupCode;

    /** 尺码组名称 */
    @Excel(name = "尺码组名称")
    private String sizeGroupName;

    /** 尺码组类型 */
    @Excel(name = "尺码组类型" , dictType = "size_type")
    private String sizeType;

    /** 是否启用 */
    @Excel(name = "是否启用", type = Excel.Type.EXPORT,dictType = "mes_item_product")
    private String enableFlag;

    public void setSizeGroupId(Long sizeGroupId)
    {
        this.sizeGroupId = sizeGroupId;
    }

    public Long getSizeGroupId()
    {
        return sizeGroupId;
    }
    public void setSizeGroupCode(String sizeGroupCode)
    {
        this.sizeGroupCode = sizeGroupCode;
    }

    @NotBlank(message = "尺码组编码不能为空")
    public String getSizeGroupCode()
    {
        return sizeGroupCode;
    }
    public void setSizeGroupName(String sizeGroupName)
    {
        this.sizeGroupName = sizeGroupName;
    }

    @NotBlank(message = "尺码组名称不能为空")
    public String getSizeGroupName()
    {
        return sizeGroupName;
    }
    public void setSizeType(String sizeType)
    {
        this.sizeType = sizeType;
    }

    @NotBlank(message = "尺码组类型不能为空")
    public String getSizeType()
    {
        return sizeType;
    }
    public void setEnableFlag(String enableFlag)
    {
        this.enableFlag = enableFlag;
    }

    public String getEnableFlag()
    {
        return enableFlag;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("sizeGroupId", getSizeGroupId())
            .append("sizeGroupCode", getSizeGroupCode())
            .append("sizeGroupName", getSizeGroupName())
            .append("sizeType", getSizeType())
            .append("enableFlag", getEnableFlag())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
