package com.ximai.mes.md.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * sap特性字典数据对象 md_sap_dict_data
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@Getter
@Setter
@ToString
public class MdSapDictData {

    /**
     * $column.columnComment
     */
    @TableId(type = IdType.AUTO)
    private Long id;

    /**
     * 字典ID
     */
    @Excel(name = "字典ID")
    private Long dictId;

    @TableField(exist = false)
    private String dictName;

    /**
     * 数据数值
     */
    @Excel(name = "数据数值")
    private String value;

    /**
     * 数据名称
     */
    @Excel(name = "数据名称")
    private String name;

    /**
     * 是否启用
     */
    @Excel(name = "是否启用")
    private String enableFlag;

    private Long parentId;


    /** 创建者 */
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 更新者 */
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;


    @TableField(exist = false)
    private List<MdSapDictData> children;
}
