package com.ximai.mes.md.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 产品工厂配置对象 md_product_factory
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public class MdProductFactory extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 产品工厂id */
    private Long productFactoryId;

    /** 产品id */
    @Excel(name = "产品id")
    private Long itemId;

    /** 工厂id */
    @Excel(name = "工厂id")
    private Long factoryId;

    public Long getFactoryId() {
        return factoryId;
    }

    public void setFactoryId(Long factoryId) {
        this.factoryId = factoryId;
    }

    public void setProductFactoryId(Long productFactoryId)
    {
        this.productFactoryId = productFactoryId;
    }

    public Long getProductFactoryId()
    {
        return productFactoryId;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("productFactoryId", getProductFactoryId())
            .append("itemId", getItemId())
            .append("factoryId", getFactoryId())
            .toString();
    }
}
