package com.ximai.mes.md.domain;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 客户付款信息关联对象 md_client_payment_relation
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
@Getter
@Setter
@ToString
public class MdClientPaymentRelation extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * $column.columnComment
     */
    private String id;

    /**
     * 客户编码
     */
    @Excel(name = "客户编码")
    private String clientCode;

    /**
     * 支付方客户ID
     */
    @Excel(name = "支付方客户ID")
    private Long relatedClientId;

    private String relatedName;

    private String relatedCode;

}
