package com.ximai.mes.md.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdSapDictData;
import com.ximai.mes.md.service.IMdSapDictDataService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

/**
 * sap特性字典数据Controller
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@RestController
@RequestMapping("md/sapDictData")
public class MdSapDictDataController extends BaseController {
    @Autowired
    private IMdSapDictDataService mdSapDictDataService;

    /**
     * 查询sap特性字典数据列表
     */
    @PreAuthorize("@ss.hasPermi('md:sapDictData:list')")
    @GetMapping("/page")
    public AjaxResult page(@RequestParam Map<String, Object> params) {
        final IPage<MdSapDictData> page = mdSapDictDataService.pageByMap(params);
        return AjaxResult.success(page);
    }

    /**
     * 查询sap特性字典数据列表
     */
    @PreAuthorize("@ss.hasPermi('md:sapDictData:list')")
    @GetMapping("/list")
    public AjaxResult list(MdSapDictData mdSapDictData) {
        startPage();
        List<MdSapDictData> list = mdSapDictDataService.selectList(mdSapDictData);
        return AjaxResult.success(list);
    }

    /**
     * 获取sap特性字典数据详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:sapDictData:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id) {
        return AjaxResult.success(mdSapDictDataService.selectById(id));
    }

    /**
     * 新增sap特性字典数据
     */
    @PreAuthorize("@ss.hasPermi('md:sapDictData:add')")
    @Log(title = "sap特性字典数据", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdSapDictData mdSapDictData) {
        return toAjax(mdSapDictDataService.insert(mdSapDictData));
    }

    /**
     * 修改sap特性字典数据
     */
    @PreAuthorize("@ss.hasPermi('md:sapDictData:edit')")
    @Log(title = "sap特性字典数据", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdSapDictData mdSapDictData) {
        return toAjax(mdSapDictDataService.update(mdSapDictData));
    }

    /**
     * 删除sap特性字典数据
     */
    @PreAuthorize("@ss.hasPermi('md:sapDictData:remove')")
    @Log(title = "sap特性字典数据", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids) {
        return toAjax(mdSapDictDataService.deleteByIds(ids));
    }
}
