package com.ximai.mes.md.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdFaceColor;
import com.ximai.mes.md.service.MdFaceColorService;
import com.ximai.mes.md.vo.MdFaceColorVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @Auther: xin.lu
 * @Date: 2024/01/16/11:26
 * @Description:
 */
@RestController
@RequestMapping("/mes/md/faceColor")
public class MdFaceColorController extends BaseController {
    @Autowired
    private MdFaceColorService mdFaceColorService;

    /**
     * 查询产品颜色关系列表
     */
    @GetMapping("/list")
    public TableDataInfo list(MdFaceColor mdFaceColor)
    {
        startPage();
        List<MdFaceColorVo> list = mdFaceColorService.selectMdFaceColorList(mdFaceColor);
        return getDataTable(list);
    }

    /**
     * 获取产品颜色关系详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:md:faceColor:query')")
    @GetMapping(value = "/{faceColorId}")
    public AjaxResult getInfo(@PathVariable("faceColorId") Long faceColorId)
    {
        return AjaxResult.success(mdFaceColorService.selectMdFaceColorByFaceColorId(faceColorId));
    }

    /**
     * 新增产品颜色关系
     */
    @PreAuthorize("@ss.hasPermi('mes:md:faceColor:add')")
    @Log(title = "产品颜色关系", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdFaceColor mdFaceColor) {
        //检验不能重复添加
        //mdFaceColorService.checkMdFaceColorUnique(mdFaceColor);
        mdFaceColor.setCreateBy(getUsername());
        return toAjax(mdFaceColorService.insertMdFaceColor(mdFaceColor));
    }

    /**
     * 修改产品颜色关系
     */
    @PreAuthorize("@ss.hasPermi('mes:md:faceColor:edit')")
    @Log(title = "产品颜色关系", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdFaceColor mdFaceColor)
    {
        mdFaceColor.setUpdateBy(getUsername());
        return toAjax(mdFaceColorService.updateMdFaceColor(mdFaceColor));
    }

    /**
     * 删除产品颜色关系
     */
    @PreAuthorize("@ss.hasPermi('mes:md:mditem:remove')")
    @Log(title = "产品颜色关系", businessType = BusinessType.DELETE)
    @DeleteMapping("/{mdFaceColorIds}")
    public AjaxResult remove(@PathVariable Long[] mdFaceColorIds)
    {
        return toAjax(mdFaceColorService.deleteMdFaceColorByFaceColorIds(mdFaceColorIds));
    }

}
