package com.ximai.mes.md.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.ximai.common.annotation.Log;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.domain.MdBrand;
import com.ximai.mes.md.service.IMdBrandService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * title:
 * author:ZHT
 * date:2024/1/16
 * description:
 */
@RestController
@RequestMapping("/mes/md/brand")
public class MdBrandController extends BaseController{
    @Autowired
    private IMdBrandService mdBrandService;

    /**
     * 获取品牌列表
     */
    @PreAuthorize("@ss.hasPermi('mes:md:brand:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdBrand mdBrand) {
        startPage();
        List<MdBrand> list = mdBrandService.selectMdBrandList(mdBrand);
        return getDataTable(list);
    }

    /**
     * 查询所有可用的
     */
    @PreAuthorize("@ss.hasPermi('mes:md:brand:listBrand')")
    @GetMapping("/listBrand")
    public AjaxResult listAll() {
        MdBrand mdBrand = new MdBrand();
        mdBrand.setEnableFlag("Y");
        List<MdBrand> list = mdBrandService.selectMdBrandList(mdBrand);
        return AjaxResult.success(list);
    }

    /**
     * 根据id查询品牌详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:md:brand:query')")
    @GetMapping(value = "/{brandId}")
    public AjaxResult getInfo(@PathVariable("brandId") Long brandId) {
        return AjaxResult.success(mdBrandService.selectMdBrandByBrandId(brandId));
    }

    /**
     * 新增生产品牌
     */
    @PreAuthorize("@ss.hasPermi('mes:md:brand:add')")
    @Log(title = "生产品牌", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdBrand mdBrand) {
            if (UserConstants.NOT_UNIQUE.equals(mdBrandService.checkCodeUnique(mdBrand))) {
                return AjaxResult.error("工序编码已存在！");
            }
            if (UserConstants.NOT_UNIQUE.equals(mdBrandService.checkNameUnique(mdBrand))) {
                return AjaxResult.error("工序名称已存在！");
            }
            return toAjax(mdBrandService.insertMdBrand(mdBrand));
    }

    /**
     * 修改生产品牌
     */
    @PreAuthorize("@ss.hasPermi('mes:md:brand:edit')")
    @Log(title = "生产品牌", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdBrand mdBrand){
        if(UserConstants.NOT_UNIQUE.equals(mdBrandService.checkCodeUnique(mdBrand))){
            return AjaxResult.error("工序编码已存在！");
        }
        if(UserConstants.NOT_UNIQUE.equals(mdBrandService.checkNameUnique(mdBrand))){
            return AjaxResult.error("工序名称已存在！");
        }
        return toAjax(mdBrandService.updateMdBrand(mdBrand));
    }

//    /**
//     * 批量删除指定的品牌
//     */
//    @PreAuthorize("@ss.hasPermi('mes:md:brand:remove')")
//    @Log(title = "生产品牌", businessType = BusinessType.DELETE)
//    @DeleteMapping("/{brandId}")
//    public AjaxResult remove(@PathVariable Long brandIds)
//    {
//        return toAjax(mdBrandService.deleteMdBrandByBrandIds(brandIds));
//    }

    /**
     * 批量删除指定的品牌
     */
    @PreAuthorize("@ss.hasPermi('mes:md:brand:remove')")
    @Log(title = "生产品牌", businessType = BusinessType.DELETE)
    @DeleteMapping("/{brandId}")
    public AjaxResult remove(@PathVariable Long brandId)
    {
        return toAjax(mdBrandService.deleteMdBrandByBrandId(brandId));
    }

    /**
     * 根据条件查询所有可用的
     */
    @PreAuthorize("@ss.hasPermi('mes:md:brand:listBrandByCondition')")
    @GetMapping("/listBrandByCondition")
    public AjaxResult listBrandByCondition(MdBrand mdBrand) {
        List<MdBrand> list = mdBrandService.selectMdBrandList(mdBrand);
        return AjaxResult.success(list);
    }

}
