package com.ximai.mes.md.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdBaseInfo;
import com.ximai.mes.md.service.IMdBaseInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

/**
 * 产品基本信息Controller
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
@RestController
@RequestMapping("/md/info")
public class MdBaseInfoController extends BaseController {
    @Autowired
    private IMdBaseInfoService mdBaseInfoService;

    /**
     * 获取产品基本信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:info:query')")
    @GetMapping(value = "/{itemId}")
    public AjaxResult getInfo(@PathVariable("itemId") Long itemId) {
        return AjaxResult.success(mdBaseInfoService.selectMdBaseInfoByItemId(itemId));
    }

    /**
     * 新增产品基本信息
     */
    @PreAuthorize("@ss.hasPermi('md:info:add')")
    @Log(title = "产品基本信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdBaseInfo mdBaseInfo) {
        return toAjax(mdBaseInfoService.insertMdBaseInfo(mdBaseInfo));
    }

    /**
     * 修改产品基本信息
     */
    @PreAuthorize("@ss.hasPermi('md:info:edit')")
    @Log(title = "产品基本信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdBaseInfo mdBaseInfo) {
        return toAjax(mdBaseInfoService.updateMdBaseInfo(mdBaseInfo));
    }
}
