package com.ximai.mes.kanban.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.cal.domain.CalPlanWorkunit;
import com.ximai.mes.cal.mapper.CalPlanWorkunitMapper;
import com.ximai.mes.constant.QcAbnormalTypeEnum;
import com.ximai.mes.kanban.dto.BasicRatio;
import com.ximai.mes.kanban.dto.equipment.EquipmentQuery;
import com.ximai.mes.kanban.dto.equipment.EquipmentStatDto;
import com.ximai.mes.kanban.dto.material.BasicDailyData;
import com.ximai.mes.kanban.dto.material.ErpDataDto;
import com.ximai.mes.kanban.dto.material.MesDataDto;
import com.ximai.mes.md.domain.MdWorkunit;
import com.ximai.mes.md.service.IMdWorkunitService;
import com.ximai.mes.pro.domain.ProFeedback;
import com.ximai.mes.pro.domain.vo.ProFeedbackVo;
import com.ximai.mes.pro.dto.task.WorkunitProcessingDto;
import com.ximai.mes.pro.mapper.task.ProTaskWorkunitMapper;
import com.ximai.mes.pro.service.IProFeedbackService;
import com.ximai.mes.qc.domain.QcAbnormalReport;
import com.ximai.mes.qc.dto.QcAbnormalReportDto;
import com.ximai.mes.qc.dto.QcAbnormalReportStatusEnum;
import com.ximai.mes.qc.mapper.QcAbnormalReportMapper;
import com.ximai.mes.qc.service.IQcAbnormalReportService;
import com.ximai.mes.remote.ErpKanbanService;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

@Service
public class KanbanMaterialService {

    @Autowired
    private IProFeedbackService feedbackService;
    @Autowired
    private ProTaskWorkunitMapper taskWorkunitMapper;
    @Autowired
    private CalPlanWorkunitMapper calPlanWorkunitMapper;
    @Autowired
    private ErpKanbanService erpKanbanService;

    public ErpDataDto getErpData(){
        ErpDataDto rst = erpKanbanService.getMaterialStat().getData();
        rst.getSalesOutboundPlanList().forEach(s->{
            s.setItemName(s.getItemNo());
        });
        return rst;
    }

    public MesDataDto getMesData(){
        MesDataDto rst = new MesDataDto();
        LocalDateTime currMonth = LocalDateTime.now().withDayOfMonth(1).with(LocalTime.MIN);
        LocalDateTime nextMonth = currMonth.plusMonths(1);
        BasicRatio basicRatio = taskWorkunitMapper.selectStockInCompleteRatio(currMonth, nextMonth);
        if(basicRatio.getDenominator()!=null&&basicRatio.getDenominator().compareTo(BigDecimal.ZERO)!=0){
            rst.setStockInCompleteRatio(basicRatio.getNumerator().divide(basicRatio.getDenominator(), 3, BigDecimal.ROUND_DOWN).multiply(new BigDecimal("100")));
        }
        List<MesDataDto.OrderInfoDto> orderInfoList = taskWorkunitMapper.selectTaskWorkUnitWithKanban2(currMonth, nextMonth);
        rst.setOrderInfoList(orderInfoList);
        return rst;
    }


}
