package com.ximai.mes.kanban.dto.task;

import com.ximai.mes.pro.domain.task.ProTaskWorkunit;
import com.ximai.mes.pro.dto.task.ProTaskWorkunitDto;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * 生产计划看板
 */
@Data
public class TaskPlanStatDto {

    @ApiModelProperty("按日统计加工产品")
    List<TaskPlanDay> taskPlanDayList;


    @Data
    public static class TaskPlanDay{

        @ApiModelProperty("开始日期")
        private String startDate;

        @ApiModelProperty("产品列表")
        private List<ProductTaskInfo> productList;

    }

    @Data
    public static class ProductTaskInfo{

        @ApiModelProperty("产品编号")
        private String itemCode;

        @ApiModelProperty("计划数")
        private BigDecimal planQuantity;

        @ApiModelProperty("工序列表")
        private List<ProcessTaskInfo> processList;

    }

    @Data
    public static class ProcessTaskInfo{

        @ApiModelProperty("工序名称")
        private String processName;

        /**
         * 进行中0，完成1，超期未完成2
         */
        @ApiModelProperty("状态,进行中0，完成1，超期未完成2")
        private int state;

        @ApiModelProperty("报工")
        private BigDecimal reportQuantity=BigDecimal.ZERO;

        @ApiModelProperty("合格数")
        private BigDecimal qualifyQuantity=BigDecimal.ZERO;

        @ApiModelProperty("合格率")
        private BigDecimal qualifiedRate=BigDecimal.ZERO;

        @ApiModelProperty("计划数")
        private BigDecimal planQuantity=BigDecimal.ZERO;

    }


    @Data
    public static class TaskWorkunitGroup{
        String startDate;
        String itemCode;
        List<ProTaskWorkunitDto> taskWorkunitList;
    }

    @Data
    @AllArgsConstructor
    public static class TaskWorkunitProcessKey{
        String processName;
        int idx;
    }

}
