package com.ximai.mes.kanban.dto.material;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class MesDataDto {

    @ApiModelProperty("生产入库完成率")
    BigDecimal stockInCompleteRatio;

    @ApiModelProperty("生产入库计划")
    List<OrderInfoDto> orderInfoList;


    @Data
    public static class OrderInfoDto{

        @ApiModelProperty("生产工单")
        String workorderNo;
        @ApiModelProperty("产品名称")
        String itemName;
        @ApiModelProperty("计划入库时间")
        @JsonFormat(pattern = "yyyy-MM-dd HH:mm")
        Date planFinishDate;
        @ApiModelProperty("任务数量")
        BigDecimal planQuantity;
        @ApiModelProperty("完成数量")
        BigDecimal finishQuantity;

    }


}
