package com.ximai.mes.dv.service.impl.dvBrandQuotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.dv.domain.vo.DevBrandQuotationProcessQcindexVo;
import com.ximai.mes.qc.domain.QcIndex;
import com.ximai.mes.qc.mapper.QcIndexMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.dv.mapper.devBrandQuotation.DevBrandQuotationProcessQcindexMapper;
import com.ximai.mes.dv.domain.devBrandQuotation.DevBrandQuotationProcessQcindex;
import com.ximai.mes.dv.service.devBrandQuotation.IDevBrandQuotationProcessQcindexService;

/**
 * 品牌报价工序检验项Service业务层处理
 *
 * @author generator
 * @date 2024-01-28
 */
@Service
public class DevBrandQuotationProcessQcindexServiceImpl implements IDevBrandQuotationProcessQcindexService
{
    @Autowired
    private DevBrandQuotationProcessQcindexMapper devBrandQuotationProcessQcindexMapper;

    @Autowired
    private QcIndexMapper qcIndexMapper;

    /**
     * 查询品牌报价工序检验项
     *
     * @param brandQuotationProcessQcindexId 品牌报价工序检验项主键
     * @return 品牌报价工序检验项
     */
    @Override
    public DevBrandQuotationProcessQcindex selectDevBrandQuotationProcessQcindexByBrandQuotationProcessQcindexId(Long brandQuotationProcessQcindexId)
    {
        return devBrandQuotationProcessQcindexMapper.selectDevBrandQuotationProcessQcindexByBrandQuotationProcessQcindexId(brandQuotationProcessQcindexId);
    }

    /**
     * 查询品牌报价工序检验项列表
     *
     * @param devBrandQuotationProcessQcindex 品牌报价工序检验项
     * @return 品牌报价工序检验项
     */
    @Override
    public List<DevBrandQuotationProcessQcindex> selectDevBrandQuotationProcessQcindexList(DevBrandQuotationProcessQcindex devBrandQuotationProcessQcindex)
    {
        return devBrandQuotationProcessQcindexMapper.selectDevBrandQuotationProcessQcindexList(devBrandQuotationProcessQcindex);
    }

    /**
     * 新增品牌报价工序检验项
     *
     * @param devBrandQuotationProcessQcindex 品牌报价工序检验项
     * @return 结果
     */
    @Override
    public int insertDevBrandQuotationProcessQcindex(DevBrandQuotationProcessQcindex devBrandQuotationProcessQcindex)
    {
        return devBrandQuotationProcessQcindexMapper.insertDevBrandQuotationProcessQcindex(devBrandQuotationProcessQcindex);
    }

    /**
     * 修改品牌报价工序检验项
     *
     * @param devBrandQuotationProcessQcindex 品牌报价工序检验项
     * @return 结果
     */
    @Override
    public int updateDevBrandQuotationProcessQcindex(DevBrandQuotationProcessQcindex devBrandQuotationProcessQcindex)
    {
        return devBrandQuotationProcessQcindexMapper.updateDevBrandQuotationProcessQcindex(devBrandQuotationProcessQcindex);
    }

    /**
     * 批量删除品牌报价工序检验项
     *
     * @param brandQuotationProcessQcindexIds 需要删除的品牌报价工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteDevBrandQuotationProcessQcindexByBrandQuotationProcessQcindexIds(Long[] brandQuotationProcessQcindexIds)
    {
        return devBrandQuotationProcessQcindexMapper.deleteDevBrandQuotationProcessQcindexByBrandQuotationProcessQcindexIds(brandQuotationProcessQcindexIds);
    }

    /**
     * 删除品牌报价工序检验项信息
     *
     * @param brandQuotationProcessQcindexId 品牌报价工序检验项主键
     * @return 结果
     */
    @Override
    public int deleteDevBrandQuotationProcessQcindexByBrandQuotationProcessQcindexId(Long brandQuotationProcessQcindexId)
    {
        return devBrandQuotationProcessQcindexMapper.deleteDevBrandQuotationProcessQcindexByBrandQuotationProcessQcindexId(brandQuotationProcessQcindexId);
    }

    @Override
    public List<DevBrandQuotationProcessQcindexVo> selectDevBrandQuotationProcessQcindexVoList(DevBrandQuotationProcessQcindex devBrandQuotationProcessQcindex)
    {
        List<DevBrandQuotationProcessQcindexVo> rst = new ArrayList<DevBrandQuotationProcessQcindexVo>();
        DevBrandQuotationProcessQcindex query = new DevBrandQuotationProcessQcindex();
        query.setBrandQuotationId(devBrandQuotationProcessQcindex.getBrandQuotationId());
        List<DevBrandQuotationProcessQcindex> list = devBrandQuotationProcessQcindexMapper.selectDevBrandQuotationProcessQcindexList(query);
        List<Long> ids = list.stream().map(s->s.getQcindexId()).collect(Collectors.toList());
        Map<Long, QcIndex> qcIndexMap = new HashMap<Long, QcIndex>();
        if(ids.size()>0){
            qcIndexMap.putAll(qcIndexMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(s->s.getIndexId(), s->s)));
        }
        list.forEach(s->{
            DevBrandQuotationProcessQcindexVo vo = new DevBrandQuotationProcessQcindexVo();
            BeanUtil.copyProperties(s, vo);
            if(qcIndexMap.containsKey(s.getQcindexId())){
                BeanUtil.copyProperties(qcIndexMap.get(s.getQcindexId()), vo);
            }
            rst.add(vo);
        });
        return rst;
    }
}
