package com.ximai.mes.dv.service.devBrandQuotation;

import java.util.List;
import com.ximai.mes.dv.domain.devBrandQuotation.DevBrandQuotationProcessTool;
import com.ximai.mes.dv.domain.vo.DevBrandQuotationProcessToolVo;

/**
 * 品牌报价工序工装夹具Service接口
 *
 * @author generator
 * @date 2024-01-28
 */
public interface IDevBrandQuotationProcessToolService
{
    /**
     * 查询品牌报价工序工装夹具
     *
     * @param brandQuotationProcessToolId 品牌报价工序工装夹具主键
     * @return 品牌报价工序工装夹具
     */
    public DevBrandQuotationProcessTool selectDevBrandQuotationProcessToolByBrandQuotationProcessToolId(Long brandQuotationProcessToolId);

    /**
     * 查询品牌报价工序工装夹具列表
     *
     * @param devBrandQuotationProcessTool 品牌报价工序工装夹具
     * @return 品牌报价工序工装夹具集合
     */
    public List<DevBrandQuotationProcessTool> selectDevBrandQuotationProcessToolList(DevBrandQuotationProcessTool devBrandQuotationProcessTool);

    /**
     * 新增品牌报价工序工装夹具
     *
     * @param devBrandQuotationProcessTool 品牌报价工序工装夹具
     * @return 结果
     */
    public int insertDevBrandQuotationProcessTool(DevBrandQuotationProcessTool devBrandQuotationProcessTool);

    /**
     * 修改品牌报价工序工装夹具
     *
     * @param devBrandQuotationProcessTool 品牌报价工序工装夹具
     * @return 结果
     */
    public int updateDevBrandQuotationProcessTool(DevBrandQuotationProcessTool devBrandQuotationProcessTool);

    /**
     * 批量删除品牌报价工序工装夹具
     *
     * @param brandQuotationProcessToolIds 需要删除的品牌报价工序工装夹具主键集合
     * @return 结果
     */
    public int deleteDevBrandQuotationProcessToolByBrandQuotationProcessToolIds(Long[] brandQuotationProcessToolIds);

    /**
     * 删除品牌报价工序工装夹具信息
     *
     * @param brandQuotationProcessToolId 品牌报价工序工装夹具主键
     * @return 结果
     */
    public int deleteDevBrandQuotationProcessToolByBrandQuotationProcessToolId(Long brandQuotationProcessToolId);

    public List<DevBrandQuotationProcessToolVo> selectDevBrandQuotationProcessToolVoList(DevBrandQuotationProcessTool devBrandQuotationProcessTool);
}
