package com.ximai.mes.constant;

/**
 * 任务单状态
 *
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum TmToolMachineTypeEnum {

    /**
     * 未开工 开工 停工
     */
    MOUNT(1, "已上机"),
    /**
     * 已开工
     */
    DIS_MOUNT(2, "已下机"),
//    NOT_BOND(4, "待上机"),
    /**
     * 暂停
     */
    INIT(3, "待上机");

    /**
     * Lock type
     */
    private final Integer type;
    private final String value;

    TmToolMachineTypeEnum(Integer type, String value) {
        this.type = type;
        this.value = value;
    }

    public Integer getType() {
        return type;
    }

    public String getValue() {
        return value;
    }

    public static String get(Integer type) {
        for (TmToolMachineTypeEnum temp : TmToolMachineTypeEnum.values()) {
            if (temp.getType().equals(type)) {
                return temp.getValue();
            }
        }
        return TmToolMachineTypeEnum.INIT.getValue();
//        throw new RuntimeException("异常上机类型");
    }
}
