package com.ximai.mes.constant;

/**
 * 任务单状态
 *
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum QcAbnormalTypeEnum {

    /**
     * 生产异常
     */
    PROD("PROD", "生产异常"),

    /**
     * 质量异常
     */
    QUAL("QUAL", "质量异常"),

    /**
     * 设备异常
     */
    DEVI("DEVI", "设备异常");

    /**
     * Lock type
     */
    private final String type;

    private final String statusCn;

    QcAbnormalTypeEnum(String type, String statusCn) {
        this.type = type;
        this.statusCn = statusCn;
    }

    public String getType() {
        return type;
    }

    public String getStatusCn() {
        return statusCn;
    }

    public static QcAbnormalTypeEnum get(String type) {
        for (QcAbnormalTypeEnum temp : QcAbnormalTypeEnum.values()) {
            if (temp.getType().equals(type)) {
                return temp;
            }
        }
        return null;
    }


}
