package com.ximai.mes.cal.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.common.utils.excel.converter.DateTimeConverter;
import com.ximai.mes.cal.domain.CalShift;
import com.ximai.mes.cal.domain.CalWorkunit;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;
import java.util.List;

/**
 * 排班计划对象 cal_plan
 *
 * @date 2022-06-06
 */
@Data
@ApiModel(description = "排班计划实体")
public class CalPlanExcelExport  {

    /**
     * 计划编号
     */
    @ApiModelProperty(value = "计划编号")
    @ExcelProperty("计划编号")
    private String planCode;

    /**
     * 计划名称
     */
    @ApiModelProperty(value = "计划名称")
    @ExcelProperty("计划名称")
    private String planName;

    private String calendarType;

    /**
     * 开始日期
     */
    @ApiModelProperty(value = "计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty(value="开始日期", converter = DateTimeConverter.class)
    private Date startDate;

    /**
     * 结束日期
     */
    @ApiModelProperty(value = "计划结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @ExcelProperty(value = "结束日期", converter = DateTimeConverter.class)
    private Date endDate;

    /**
     * 轮班方式
     */
    @ApiModelProperty(value = "轮班方式 SHIFT_THREE/SHIFT_TWO/SHIFT_ONE")
    @ExcelProperty("轮班方式")
    private String shiftType;

    /**
     * 倒班方式
     */
    @ExcelProperty("倒班方式")
    private String shiftMethod;

    /**
     * 数
     */
    @ExcelProperty("数")
    private Long shiftCount;


}
